<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueu scripts */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_enqueue_scripts')) {

	function incanto_lite_enqueue_scripts() {

		wp_deregister_style( 'avventura-lite-style' );
		wp_deregister_style( 'avventura-lite-' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')) );

		wp_enqueue_style( 'avventura-lite-parent-style' , get_template_directory_uri() . '/style.css' );

		wp_enqueue_style(
			'incanto-lite-' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')),
			get_stylesheet_directory_uri() . '/assets/skins/' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')) . '.css',
			array( 'incanto-lite-style' ),
			'1.0.0'
		);

		wp_enqueue_style( 'incanto-lite-style' , get_stylesheet_directory_uri() . '/style.css' );

		$googleFontsArgs = array(
			'family' =>	str_replace('|', '%7C','Merriweather:300,300i,400,400i,700,700i,900,900i'),
			'subset' =>	'latin,latin-ext'
		);

		wp_deregister_style('google-fonts');
		wp_enqueue_style('google-fonts', add_query_arg ( $googleFontsArgs, "https://fonts.googleapis.com/css" ), array(), '1.0.0' );

	}

	add_action( 'wp_enqueue_scripts', 'incanto_lite_enqueue_scripts', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Replace hooks */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_replace_hooks')) {

	function incanto_lite_replace_hooks() {

		remove_action('avventura_lite_top_sidebar', 'avventura_lite_top_sidebar_function');
		remove_action('avventura_lite_scroll_sidebar', 'avventura_lite_scroll_sidebar_function');
		remove_action('avventura_lite_thumbnail', 'avventura_lite_thumbnail_function');
		remove_action('post_class', 'avventura_lite_post_class');
		remove_action('avventura_lite_before_content', 'avventura_lite_before_content_function' );
		remove_action('avventura_lite_slick_slider', 'avventura_lite_slick_slider_function');
		remove_action('woocommerce_before_main_content', 'avventura_lite_woocommerce_before_main_content');
		remove_action('woocommerce_after_main_content', 'avventura_lite_woocommerce_after_main_content');
		remove_filter('get_the_excerpt', 'avventura_lite_customize_excerpt_more' );

	}

	add_action('init','incanto_lite_replace_hooks');

}

/*-----------------------------------------------------------------------------------*/
/* Exclude sticky posts on home */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_is_featured_posts_on_archive')) {

	function incanto_lite_is_featured_posts_on_archive() {

		if (
			is_author() ||
			is_category() ||
			is_tag() ||
			is_tax('post_format')
		) :

			return true;

		else :

			return false;

		endif;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Exclude sticky posts on home */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_get_categories')) {

	function incanto_lite_get_categories() {

		$args = array(
			'taxonomy' => 'category',
			'hide_empty' => true,
		);

		foreach ( get_terms($args) as $cat) {
			$return[$cat->term_id] = $cat->name;
		}

		return $return;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Customize register */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_customize_register')) {

	function incanto_lite_customize_register( $wp_customize ) {

		$wp_customize->remove_control( 'avventura_lite_view_category_title');
		$wp_customize->remove_control( 'avventura_lite_view_searched_item');
		$wp_customize->remove_control( 'avventura_lite_slideshow_post_details');
		$wp_customize->remove_control( 'avventura_lite_header_layout');
		$wp_customize->remove_control( 'avventura_lite_home');
		$wp_customize->remove_control( 'avventura_lite_category_layout');
		$wp_customize->remove_control( 'avventura_lite_search_layout');
		$wp_customize->remove_control( 'avventura_lite_homepage_slideshow_position');
		$wp_customize->remove_control( 'avventura_lite_slideshow_overlay');

		$wp_customize->add_setting( 'incanto_lite_logo_background_color', array(
			'default' => '#222222',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control( 'incanto_lite_logo_background_color' , array(
			'type' => 'color',
			'section' => 'colors',
			'label' => esc_html__('Background color for the logo section','incanto-lite'),
			'description' => esc_html__('Choose your custom color for the logo section when a header image is not defined.','incanto-lite'),
		));

		$wp_customize->add_setting( 'incanto_lite_logo_text_color', array(
			'default' => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control( 'incanto_lite_logo_text_color' , array(
			'type' => 'color',
			'section' => 'colors',
			'label' => esc_html__('Logo text color','incanto-lite'),
			'description' => esc_html__('Choose your custom color for the logo.','incanto-lite'),
		));

		$wp_customize->add_setting( 'incanto_lite_featured_posts', array(
			'default' => 'layout-1',
			'sanitize_callback' => 'incanto_lite_select_sanitize',
		));

		$wp_customize->add_control( 'incanto_lite_featured_posts' , array(
			'priority' => 9,
			'type' => 'select',
			'section' => 'layouts_section',
			'label' => esc_html__('Feaured post grid','incanto-lite'),
			'description' => esc_html__('To enable the feaured post grid on archive and search pages, please select one of available layouts.','incanto-lite'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','incanto-lite'),
			   'layout-1' => esc_html__( 'Layout 1','incanto-lite'),
			   'layout-2' => esc_html__( 'Layout 2','incanto-lite'),
			   'layout-3' => esc_html__( 'Layout 3','incanto-lite'),
			   'layout-4' => esc_html__( 'Layout 4','incanto-lite'),
			),
		));

		$wp_customize->add_panel( 'incanto_lite_postblock_panel', array(
			'title' => esc_html__( 'Incanto Lite Post Blocks', 'incanto-lite' ),
			'description' => esc_html__( 'Incanto Lite Post Block', 'incanto-lite' ),
			'priority' => 13,
		));

		$wp_customize->add_section('incanto_lite_postblock_1', array(
			'title' => esc_html__( 'Incanto Lite postBlock 1', 'incanto-lite' ),
			'panel' => 'incanto_lite_postblock_panel',
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_1_category', array(
			'default' => 1,
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_1_category' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_1',
			'label' => esc_html__('Category','incanto-lite'),
			'description' => esc_html__('Please select the category of this postblock.','incanto-lite'),
			'choices'  => incanto_lite_get_categories(),
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_1_layout', array(
			'default' => 'module-1',
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_1_layout' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_1',
			'label' => esc_html__('Layout','incanto-lite'),
			'description' => esc_html__('Please select the layout of this postblock.','incanto-lite'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','incanto-lite'),
			   'module-1' => esc_html__( 'Module 1','incanto-lite'),
			   'module-2' => esc_html__( 'Module 2','incanto-lite'),
			   'module-3' => esc_html__( 'Module 3','incanto-lite'),
			   'module-4' => esc_html__( 'Module 4','incanto-lite'),
			),
		));

		$wp_customize->add_section('incanto_lite_postblock_2', array(
			'title' => esc_html__( 'Incanto Lite postBlock 2', 'incanto-lite' ),
			'panel' => 'incanto_lite_postblock_panel',
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_2_category', array(
			'default' => 1,
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_2_category' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_2',
			'label' => esc_html__('Category','incanto-lite'),
			'description' => esc_html__('Please select the category of this postblock.','incanto-lite'),
			'choices'  => incanto_lite_get_categories(),
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_2_layout', array(
			'default' => 'disable',
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_2_layout' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_2',
			'label' => esc_html__('Layout','incanto-lite'),
			'description' => esc_html__('Please select the layout of this postblock.','incanto-lite'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','incanto-lite'),
			   'module-1' => esc_html__( 'Module 1','incanto-lite'),
			   'module-2' => esc_html__( 'Module 2','incanto-lite'),
			   'module-3' => esc_html__( 'Module 3','incanto-lite'),
			   'module-4' => esc_html__( 'Module 4','incanto-lite'),
			),
		));

		$wp_customize->add_section('incanto_lite_postblock_3', array(
			'title' => esc_html__( 'Incanto Lite postBlock 3', 'incanto-lite' ),
			'panel' => 'incanto_lite_postblock_panel',
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_3_category', array(
			'default' => 1,
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_3_category' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_3',
			'label' => esc_html__('Category','incanto-lite'),
			'description' => esc_html__('Please select the category of this postblock.','incanto-lite'),
			'choices'  => incanto_lite_get_categories(),
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_3_layout', array(
			'default' => 'disable',
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_3_layout' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_3',
			'label' => esc_html__('Layout','incanto-lite'),
			'description' => esc_html__('Please select the layout of this postblock.','incanto-lite'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','incanto-lite'),
			   'module-1' => esc_html__( 'Module 1','incanto-lite'),
			   'module-2' => esc_html__( 'Module 2','incanto-lite'),
			   'module-3' => esc_html__( 'Module 3','incanto-lite'),
			   'module-4' => esc_html__( 'Module 4','incanto-lite'),
			),
		));

		$wp_customize->add_section('incanto_lite_postblock_4', array(
			'title' => esc_html__( 'Incanto Lite postBlock 4', 'incanto-lite' ),
			'panel' => 'incanto_lite_postblock_panel',
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_4_category', array(
			'default' => 1,
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_4_category' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_4',
			'label' => esc_html__('Category','incanto-lite'),
			'description' => esc_html__('Please select the category of this postblock.','incanto-lite'),
			'choices'  => incanto_lite_get_categories(),
		));

		$wp_customize->add_setting( 'incanto_lite_postblock_4_layout', array(
			'default' => 'disable',
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_postblock_4_layout' , array(
			'type' => 'select',
			'section' => 'incanto_lite_postblock_4',
			'label' => esc_html__('Layout','incanto-lite'),
			'description' => esc_html__('Please select the layout of this postblock.','incanto-lite'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','incanto-lite'),
			   'module-1' => esc_html__( 'Module 1','incanto-lite'),
			   'module-2' => esc_html__( 'Module 2','incanto-lite'),
			   'module-3' => esc_html__( 'Module 3','incanto-lite'),
			   'module-4' => esc_html__( 'Module 4','incanto-lite'),
			),
		));

		$wp_customize->add_setting( 'incanto_lite_enable_related_posts', array(
			'default' => 'on',
			'sanitize_callback' => 'incanto_lite_select_sanitize',

		));

		$wp_customize->add_control( 'incanto_lite_enable_related_posts' , array(
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Related posts','incanto-lite'),
			'description' => esc_html__('Do you want to display the related posts at the end of each article?','incanto-lite'),
			'choices'  => array (
			   'off' => esc_html__( 'No','incanto-lite'),
			   'on' => esc_html__( 'Yes','incanto-lite'),
			),
		));

		function incanto_lite_select_sanitize ($value, $setting) {

			global $wp_customize;

			$control = $wp_customize->get_control( $setting->id );

			if ( array_key_exists( $value, $control->choices ) ) {

				return $value;

			} else {

				return $setting->default;

			}

		}

	}

	add_action( 'customize_register', 'incanto_lite_customize_register', 11 );

}

/*-----------------------------------------------------------------------------------*/
/* Theme setup */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_theme_setup')) {

	function incanto_lite_theme_setup() {

		load_child_theme_textdomain( 'incanto-lite', get_stylesheet_directory() . '/languages' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/function-style.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/main-article.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/small-article.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/hero-article.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/modules/module-1.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/modules/module-2.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/modules/module-3.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/modules/module-4.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/post-icon.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/before-content.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/slick-slider.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/featured-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/media.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/post-blocks.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/related-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/top-section.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/sidebars/top-sidebar.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/sidebars/scroll-sidebar.php' );

		remove_theme_support( 'custom-logo');
		remove_theme_support( 'custom-background');

		add_theme_support( 'custom-background', array(
			'default-color' => 'ffffff',
		));

		add_theme_support( 'custom-logo', array(
			'header-text' => array(
				'site-title',
				'site-description'
			)
		));

		add_theme_support( 'custom-header', array(
			'width'         => 1170,
			'height'        => 260,
			'header-text' 	=> false
		));

		add_image_size( 'incanto_lite_small_image', 150, 120, TRUE );
		add_image_size( 'incanto_lite_medium_image', 435, 280, TRUE );
		add_image_size( 'incanto_lite_large_image', 515, 380, TRUE );

		if ( !get_theme_mod('avventura_lite_logo_font_size') )
			set_theme_mod( 'avventura_lite_logo_font_size', '60px' );

		if ( !get_theme_mod('avventura_lite_logo_description_top_margin') )
			set_theme_mod( 'avventura_lite_logo_description_top_margin', '25px' );

		if ( !get_theme_mod('avventura_lite_screen2') )
			set_theme_mod( 'avventura_lite_screen2', '970' );

		if ( !get_theme_mod('avventura_lite_screen3') )
			set_theme_mod( 'avventura_lite_screen3', '1170' );

		if ( !get_theme_mod('avventura_lite_screen4') )
			set_theme_mod( 'avventura_lite_screen4', '1370' );

	}

	add_action( 'after_setup_theme', 'incanto_lite_theme_setup');

}

/*-----------------------------------------------------------------------------------*/
/* Post class */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_post_class')) {

	function incanto_lite_post_class($classes) {

		if ( !avventura_lite_is_single() ) {

			if (
				is_home() ||
				is_archive() ||
				is_search()

			) {

				$classes[] = 'post-container masonry-item col-md-6';

			}

		} else if ( avventura_lite_is_single() && avventura_lite_is_woocommerce_active('is_cart') ) {

			$classes[] = 'post-container col-md-12 woocommerce_cart_page';

		} else if ( avventura_lite_is_single() && !avventura_lite_is_woocommerce_active('is_product') ) {

			$classes[] = 'post-container col-md-12';

		} else if ( is_page() ) {

			$classes[] = 'full';

		}

		return $classes;

	}

	add_filter('post_class', 'incanto_lite_post_class');

}

/*-----------------------------------------------------------------------------------*/
/* Body class */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_body_class')) {

	function incanto_lite_body_class($classes) {

		if (
			get_background_image() !== '' ||
			get_background_color() !== 'ffffff'
		) {
			$classes[] = 'boxed-wrapper-content';
		}

		return $classes;
	}

	add_filter('body_class', 'incanto_lite_body_class');

}

/*-----------------------------------------------------------------------------------*/
/* Set excerpt length */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_excerpt_length')) {

	function incanto_lite_excerpt_length($length) {

		$limit = $length;

		if ( doing_action( 'incanto_lite_slick_slider' ) ) {

			$limit = 10;

		} else {

			$limit = $length;

		}

		return $limit;

	}

	add_filter( 'excerpt_length', 'incanto_lite_excerpt_length', 999 );

}


/*-----------------------------------------------------------------------------------*/
/* Customize excerpt more */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_customize_excerpt_more')) {

	function incanto_lite_customize_excerpt_more( $excerpt ) {

		global $post;

		if (
			doing_action( 'incanto_lite_slick_slider' ) ||
			avventura_lite_is_single()
		) :

			return $excerpt;

		else:

			$allowed = array(
				'span' => array(
					'class' => array(),
				),
			);

			$class = 'button ';
			$button = esc_html__('Read More','incanto-lite');
			$container = 'class="read-more"';

			if ( avventura_lite_setting('avventura_lite_readmore_layout') == "default" || !avventura_lite_setting('avventura_lite_readmore_layout') ) :

				$class = 'button ' . esc_attr(avventura_lite_setting('avventura_lite_readmore_layout'));
				$button = esc_html__('Read More','incanto-lite');
				$container = 'class="read-more"';

			else :

				$class = 'nobutton';
				$button = ' [&hellip;] ';
				$container = '';

			endif;

			if (
				( $pos=strpos($post->post_content, '<!--more-->') ) &&
				!has_excerpt($post->ID)
			):

				$content = apply_filters( 'the_content', get_the_content());

			else:

				$content = $excerpt;

			endif;

			return $content . '<div class="read-more-wrapper"><a '. wp_kses($container, $allowed) . ' href="' . esc_url(get_permalink($post->ID)) . '" title="'.esc_attr__('Read More','incanto-lite').'"> <span class="'.esc_attr($class).'">'.$button.'</span></a></div>';

		endif;


	}

	add_filter( 'get_the_excerpt', 'incanto_lite_customize_excerpt_more' );

}

/*-----------------------------------------------------------------------------------*/
/* Woocommerce before content */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_woocommerce_before_main_content')) {

	function incanto_lite_woocommerce_before_main_content() {

		if ( is_product() ) {

			$classes = "product-wrapper" ;

		} else {

			$classes = "product-wrapper products-list" ;

		}

		get_sidebar('top');
		get_sidebar('header');

?>

    <div id="content-wrapper">

        <div class="container">

            <div class="row">

                <div class="<?php echo avventura_lite_template('span') . " " . avventura_lite_template('sidebar') . " " . $classes; ?>" >

<?php

	}

	add_action('woocommerce_before_main_content', 'incanto_lite_woocommerce_before_main_content');

}

/*-----------------------------------------------------------------------------------*/
/* Woocommerce after content */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_woocommerce_after_main_content')) {

	function incanto_lite_woocommerce_after_main_content() { ?>

                </div>

                <?php get_sidebar(); ?>

            </div>

        </div>

	</div>

<?php

	}

	add_action('woocommerce_after_main_content', 'incanto_lite_woocommerce_after_main_content');

}


/*-----------------------------------------------------------------------------------*/
/* Customize scroll widget area title */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('incanto_lite_dynamic_sidebar_params')) {

	function incanto_lite_dynamic_sidebar_params($params) {

		if ($params[0]['id'] == 'avventura-lite-scroll-widget-area' ) {

			$params[0]['before_title'] = '<h4 class="title"><span>';
			$params[0]['after_title'] = '</span></h4>';

		}

		return $params;

	}

	add_filter('dynamic_sidebar_params', 'incanto_lite_dynamic_sidebar_params');

}

?>
