<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if( !class_exists( 'avventura_lite_admin_notice' ) ) {

	class avventura_lite_admin_notice {
	
		/**
		 * Constructor
		 */
		 
		public function __construct( $fields = array() ) {

			if ( 
				!get_option( 'avventura-lite-dismissed-notice') &&
				version_compare( PHP_VERSION, AVVENTURA_LITE_MIN_PHP_VERSION, '>=' )
			) {

				add_action( 'admin_notices', array(&$this, 'admin_notice') );
				add_action( 'admin_head', array( $this, 'dismiss' ) );
				add_action( 'admin_init', array(&$this, 'add_script') ,11);

            }

		}
        
		 /**
		 * Loads the notice style
		 */

		public function add_script() {

			global $wp_version;

			$file_dir = get_template_directory_uri() . '/core/admin/assets/';
			wp_enqueue_style ( 'avventura-lite-notice', $file_dir.'css/notice.css' );

		}


		/**
		 * Dismiss notice.
		 */
		
		public function dismiss() {

			if ( isset( $_GET['avventura-lite-dismiss'] ) && check_admin_referer( 'avventura-lite-dismiss-action' ) ) {
		
				update_option( 'avventura-lite-dismissed-notice', intval($_GET['avventura-lite-dismiss']) );
				remove_action( 'admin_notices', array(&$this, 'admin_notice') );
				
			} 
		
		}

		/**
		 * Admin notice.
		 */
		 
		public function admin_notice() {
			
		?>
			
            <div class="notice notice-warning">
            
            	<p>
            		<strong>
                        <?php esc_html_e( 'Upgrade to the premium version of Avventura, to enable 600+ Google Fonts, Unlimited sidebars, Portfolio section and much more.', 'avventura-lite' );  ?>
                    </strong>
                </p>
            	
                <p class="notice-coupon-message">
					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( ' Unlock a 20% discount on all plans now! Use the limited-time coupon code AVVENTURA20', 'avventura-lite' ); ?><br/>
                </p>

            	<p>
                    <a target="_blank" href="<?php echo esc_url( 'https://www.themeinprogress.com/avventura-elegant-beauty-wordpress-shop-theme/?ref=2&campaign=avventura-notice' ); ?>" class="button button-primary"><?php esc_html_e( 'Upgrade Now', 'avventura-lite' ); ?></a>
            	</p>

                <p>
                    
                    <?php

                        printf( 
                            '<p><a href="%1$s" class="dismiss-notice">' . esc_html__( 'Dismiss this notice', 'avventura-lite' ) . '</a></p>', 
                            esc_url( wp_nonce_url( add_query_arg( 'avventura-lite-dismiss', '1' ), 'avventura-lite-dismiss-action'))
                        );

                    ?>
                    
            	</p>
                    

            </div>
		
		<?php
		
		}

	}

}

new avventura_lite_admin_notice();

?>