<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - Salle </title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav"
                                href="nos-salles.php">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>

    <?php

    require "connexion.php";

    $requete='SELECT salle.*, cat1.categorie_nom as salle_cat1_nom, cat2.categorie_nom as salle_cat2_nom FROM salle INNER JOIN categorie cat1 ON salle.salle_categorie=cat1.categorie_id INNER JOIN categorie cat2 ON salle.salle_categorie2=cat2.categorie_id WHERE salle_id = ' .$_GET['id'];

    $stmt=$db->query($requete);
    $result=$stmt->fetchall(PDO::FETCH_ASSOC);
    foreach($result as $salle){
    ?>
    <div class="banniere-salle">
        <video class="background-video video<?=$salle['salle_id']?>" loop="" preload="auto" autoplay="" muted=""> <source src="<?=$salle['salle_video'] ?>" type="video/mp4"></video>
    </div>
    <section>
        <div class="lineh">
            <div class="line"></div>
            <h1 class="salle-nom"> <?=$salle['salle_nom'] ?> </h1>
            <div class="line"></div>
        </div>
        <div class="placement-page-salle">
            <div class="block-info-salle">
                <h2 class="h2-info-salle">Catégorie :</h2>
                <p class="category" > <?=$salle["salle_cat1_nom"]?>, <?=$salle["salle_cat2_nom"]?></p>
                <h2 class="h2-info-salle">Durée :</h2>
                <p class="duration"> <?=$salle['salle_duree']?>min </p>
                <h2 class="h2-info-salle">Difficulté :</h2>
                <p class="difficulty"> <?=$salle['salle_difficulte']?>/5 &#x2605;</p>
            </div>
            <p class="description-salle"> <?=$salle['salle_description'] ?> </p>
        </div>

    <?php
    }
    ?>
        <a href="choix-salles.php" class="button reservation-btn-salle">Réserver</a>
    </section>

    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>