<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style-form.css">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - Réserver une salle</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav" href="nos-salles.php">
                            Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>
    <?php

    require "connexion.php";

    $requete='SELECT salle.* FROM salle  WHERE salle_id = ' .$_GET['id'];

    $stmt=$db->query($requete);
    $result=$stmt->fetchall(PDO::FETCH_ASSOC);
    foreach($result as $salle){
    ?>

    <section class="section-form">
            <form method="POST" action="insertion.php">
                <fieldset class="form form1 form-active">
                    <p>Salle : <?=$salle['salle_nom'] ?></p>
                    <span class="text-required"><span class="required">*</span> Champs obligatoires</span>
                    <h1 class="form-header-text">
                        Choississez une date et un horaire.
                    </h1>
                    <input type="hidden" name="salle" value='<?= $_GET['id'] ?>'>
                    <label for="date">Date <span class="required">*</span> :  </label>  <br> <br>
                    <input type="date" id="date" min="<?= date('Y-m-d') ?>" name="date" required>
                    <div class="hours-buttons">
                        <div>
                            <input type="radio" class="hour" id="9h" name="hour" value="9" />
                            <label for="9h">9h00</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="10h" name="hour" value="10" />
                          <label for="10h">10h30</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="13h" name="hour" value="13" />
                          <label for="13h">13h00</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="14h" name="hour" value="14" />
                          <label for="14h">14h30</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="16h" name="hour" value="16" />
                          <label for="16h">16h00</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="17h" name="hour" value="17" />
                          <label for="17h">17h30</label>
                        </div>
                        <div>
                          <input type="radio" class="hour" id="19h" name="hour" value="19" />
                          <label for="19h">19h00</label>
                        </div>
                    </div>
                    <div class="position-form-btn">
                        <a href="choix-salles.php" class="form-btn" id="btn-1-prev">Précédent</a>
                        <input type="button" class="form-btn invisible" id="btn-1-next" value="Suivant">
                    </div>
                </fieldset>
                
                <fieldset class="form form2">
                <input type="hidden" id="real-hour" name="real-hour">
                    <p>Salle : <?=$salle['salle_nom'] ?></p>
                    <span class="text-required"><span class="required">*</span> Champs obligatoires</span>
                    <div class="form--header-container">
                        <h1 class="form--header-text">
                            Saississez vos informations.
                        </h1>
                    </div>
                    <div class="form-input-top">
                        <div class="form-input">
                            <label for="fistname" class="form-label">Prénom<span class="required">*</span></label>
                            <input id="firstname" type="text" class="form-field" name="firstname" placeholder="ex: Louis" required>
                        </div>
                
                        <div class="form-input">
                            <label for="lastname" class="form-label">Nom de Famille<span class="required">*</span></label>
                            <input id="lastname" type="text" class="form-field" name="lastname" placeholder="ex: Durand" required>
                        </div>
                    </div>
                
                    <div class="form-input">
                        <label for="email" class="form-label">Email<span class="required">*</span></label>
                        <input id="email" type="email" class="form-field" name="email" placeholder="ex: louisdr@gmail.com" required>
                    </div>
                    <div class="position-form-btn">
                        <input type="button" class="form-btn" id="btn-2-prev" value="Précédent">
                        <input type="button" class="form-btn" id="btn-2-next" value="Suivant">
                    </div>
                </fieldset>
                <fieldset class="form form-recap form3">
                    <h1 class="form--header-text" id='recapTitle'><?=$salle['salle_nom'] ?></h1>
                    <img class="img-recap" src="<?= $salle['salle_img'] ?>" alt="">
                    <p class="recap-content" id="recap-content"></p>
                    <div class="position-form-btn">
                            <input type="button" class="form-btn" id="btn-3-prev" value="Précédent">
                            <input type="submit" class="form-btn" id="btn-3-next" value="Réserver">
                    </div>
                </fieldset>
            </form>
            <div class="stepper">
                <li class="dot dot1 step-active"></li>
                <li class="dot dot2 step-inactive"></li>
                <li class="dot dot3 step-inactive"></li>
            </div>
    </section>
    <?php
    }
    ?> 

    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script src="script-form.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>