<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style-form.css">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - Nos Salles</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav" href="nos-salles.php"
                                style="color: #ffffff;">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar" value="<?=$_GET['search'] ?>">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>

    <section class="section-nos-salles">
        <h1 class="titre-nos-salles">Nos Salles</h1>
        <div class="placement-tri-salles">
            <div class="block-tri-filtre" >
                <div class="block-filtre" >
                    <p class="titre-filtre">Filtrer par catégorie :</p>
                    <ul>
                        <li><a href="nos-salles.php?filtre=Ambiance">Ambiance</a></li>
                        <li><a href="nos-salles.php?filtre=Reflexion">Réflexion</a></li>
                        <li><a href="nos-salles.php?filtre=Fouille">Fouille</a></li>
                        <li><a href="nos-salles.php?filtre=Frisson">Frisson</a></li>
                        <li><a href="nos-salles.php?filtre=Familial">Familial</a></li>
                    </ul>
                </div>
                <div class="block-tri">
                    <div class="titre-tri" >Trier par :</div>
                    <details><summary>
                                <?php
                                if(isset($_GET['tri'])){
                                    $tri = $_GET['tri'];
                                    $ordre = $_GET['ordre'];
                                    
                                    if($tri == 'duree'){
                                        if($ordre == 'ASC'){
                                            echo 'Durées Croissantes';
                                        } elseif($ordre == 'DESC'){
                                            echo 'Durées Décroissantes';
                                        }
                                    } elseif($tri == 'difficulte'){
                                        if($ordre == 'ASC'){
                                            echo 'Difficultés Croissantes';
                                        } elseif($ordre == 'DESC'){
                                            echo 'Difficultés Décroissantes';
                                        }
                                    }
                                } else {
                                    echo '- - - - -';
                                }
                              ?>
                            </summary>
                            <a href="nos-salles.php">- - - - -</a> <br>
                            <a href="nos-salles.php?tri=duree&ordre=ASC"> Durées Croissantes </a> <br>
                            <a href="nos-salles.php?tri=difficulte&ordre=ASC">Difficultés Croissantes</a> <br>
                            <a href="nos-salles.php?tri=duree&ordre=DESC">Durées Décroissantes </a> <br>
                            <a href="nos-salles.php?tri=difficulte&ordre=DESC">Difficultés Décroissantes</a>
                    </details>
                </div>
            </div>
            
            <div class="presentation-produits">
            <?php
            require "connexion.php";
            $requete='SELECT salle.*, cat1.categorie_nom as salle_cat1_nom, cat2.categorie_nom as salle_cat2_nom FROM salle INNER JOIN categorie cat1 ON salle.salle_categorie=cat1.categorie_id INNER JOIN categorie cat2 ON salle.salle_categorie2=cat2.categorie_id' ;
            
            if(isset($_GET['tri']) and isset($_GET['ordre'])){
                $requete=$requete. ' ORDER BY salle_' .$_GET['tri'].' ' .$_GET['ordre'];
            };
            if(isset($_GET['filtre'])){
                $requete=$requete. ' WHERE cat1.categorie_nom=\'' .$_GET['filtre']. '\' OR cat2.categorie_nom=\'' .$_GET['filtre'] .'\'';
            };
            if(isset($_GET['search'])){
                $requete=$requete. ' WHERE salle_nom LIKE \'%' .$_GET['search']. '%\' OR cat1.categorie_nom LIKE \'%' .$_GET['search'] .'%\' OR cat2.categorie_nom LIKE \'%' .$_GET['search'] .'%\'';
            };
            $stmt=$db->query($requete);
            $result=$stmt->fetchall(PDO::FETCH_ASSOC);
            if(isset($_GET['filtre']) or isset($_GET['tri']) or isset($_GET['ordre'])){
                if (empty($result)){
                    echo '<p class="no-result">Aucun résultat ne correspond à votre recherche</p>';
                }
                else{
                    echo '<p class="result">Il y a ' .count($result). ' résultat(s) correspondant à votre recherche</p>';
                }
            }
            foreach($result as $salle){
            ?>
                <a href="salle.php?id=<?=$salle['salle_id']?> " >
                    <div class="block-choix-salle">
                        <img class="image-presentation" src=" <?=$salle["salle_img"] ?> " alt='Photo de la salle <?=$salle["salle_nom"]?>'>
                        <h2 class="room-name"> <?=$salle["salle_nom"]?> </h2>
                        <p class="category" > <?=$salle["salle_cat1_nom"]?>, <?=$salle["salle_cat2_nom"]?></p>
                        <p class="difficulty"> <?=$salle['salle_difficulte']?>/5 &#x2605;</p>
                        <p class="duration"> <?=$salle['salle_duree']?>min </p>
                    </div>
                </a>
            <?php
            };
            ?>
            </div>
        </div>
    </section>

    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>