<!DOCTYPE html>
<html lang="fr">
    
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - Le Concept</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php" style="color: #ffffff;">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav"
                                href="nos-salles.php">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>

    <section class="section-concept">
        <h1 class="title-concept">Le Concept <br> de</h1>
        <img src="img/BrainOut-neon.png" alt="" class="neon-img" id="neon-img">
            <div data-aos="fade-left" data-aos-duration="2000" class="concept1">
                <p>
                    Bienvenue chez BrainOut, où l'aventure et le mystère vous attendent à chaque tournant. Notre concept repose sur l'idée de créer des expériences uniques d'évasion qui captivent l'imagination et défient l'esprit. Chaque salle d'escape game est soigneusement conçue pour vous transporter dans un monde rempli d'énigmes, de secrets et de surprises.
                </p>
            </div>
            <div data-aos="fade-right" data-aos-duration="2000" class="concept2" >
                <p>
                    Un escape game est une expérience immersive où les participants sont enfermés dans une salle à thème et doivent résoudre une série d'énigmes et de puzzles pour s'échapper dans un temps imparti, généralement une heure. Les joueurs doivent explorer leur environnement, trouver des indices cachés et déchiffrer des codes pour progresser dans l'histoire et atteindre leur objectif final. La coopération et la communication sont essentielles ici !
                </p>
            </div>
            
            <div data-aos="fade-left" data-aos-duration="2000" class="concept3" >
                <p>
                    Que vous soyez un novice curieux ou un joueur expérimenté, nos scénarios sont adaptés à tous les niveaux de compétence et garantissent une expérience immersive inégalée. Notre équipe dévouée est là pour vous guider tout au long de votre aventure, vous fournissant des indices subtils lorsque nécessaire, tout en vous laissant le plaisir de résoudre les défis par vous-même.
                </p>
            </div>
            <div data-aos="fade-right" data-aos-duration="2000" class="concept4" >
                <p>
                    Chez BrainOut, nous croyons que l'évasion va au-delà des simples jeux : c'est une expérience de collaboration, de réflexion et d'excitation. Venez découvrir le frisson de l'évasion avec nous et laissez-vous emporter par une aventure que vous n'oublierez jamais. Prêt à relever le défi ? Entrez chez BrainOut et laissez l'expérience commencer.
                </p>
            </div>
            <a href="nos-salles.php" class="button button-le-concept">Découvrir les salles !</a>
    </section>

    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script> 
    var neon = document.querySelector('#neon-img');
    console.log(neon);
    neon.addEventListener('mouseover', function() {
        neon.src = 'img/BrainOut-neon-hover.png';
    });
    neon.addEventListener('mouseout', function() {
        neon.src = 'img/BrainOut-neon.png';
    });
    </script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>