<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - Accueil</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400">
    <header id="top">
        <a href="#contenu" class="skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav"
                                href="nos-salles.php">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
        <div class="placement-header">
            <img src="img/Logo-BrainOut.png" alt="">
            <h1><span>B</span><span>r</span><span>a</span><span>i</span><span>n</span><span>O</span><span>u</span><span>t</span>
            </h1>
            <p class="slogan">Évadez-vous de l'ordinaire.</p>
            <a href="choix-salles.php" class="button">Réserver</a>
            <a class="container button-resa" href="#contenu">
                <div class="content">
                    <svg id="more-arrows">
                        <polygon class="arrow-top" points="37.6,27.9 1.8,1.3 3.3,0 37.6,25.3 71.9,0 73.7,1.3 " />
                        <polygon class="arrow-middle"
                            points="37.6,45.8 0.8,18.7 4.4,16.4 37.6,41.2 71.2,16.4 74.5,18.7 " />
                        <polygon class="arrow-bottom" points="37.6,64 0,36.1 5.1,32.8 37.6,56.8 70.4,32.8 75.5,36.1 " />
                    </svg>
                </div>
            </a>
        </div>
    </header>

    <section class="section-contenu1" id="contenu">
        <h2 data-aos="fade-right" data-aos-duration="1000">Un&nbsp;concept&nbsp;innovant.</h2>
        <p data-aos="fade-right" data-aos-duration="1300">Imaginez-vous plonger dans un univers
            intriguant, enfermé dans un
            lieu mystèrieux... <br>
            Votre mission, si vous l'acceptez : résoudre les nombreux défis qui se mettront en travers de votre route
            vers la liberté. Votre rôle est crucial, venez à bout des énigmes avant que le temps imparti soit écoulé...
        </p>
        <span data-aos="fade-right" data-aos-duration="1500" class="link-concept">
            <a href="le-concept.php">En savoir plus →</a>
        </span>
        <div data-aos="fade-left" data-aos-duration="1000"><img src="img/serrure.png" alt=""></div>

    </section>
    <section class="section-contenu2">

        <h2 data-aos="fade-up" data-aos-duration="1000">Des expériences uniques !</h2>
        <div class="js-slider">
            <div class="js-photos">
                <div class="js-photo ">
                    <a href="salle.php?id=4" id="4">
                        <div class="image image-slider salle4"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=5" id="5">
                        <div class="image image-slider clone1 salle5"><p class="sr-only">Aller à la salle : Chambre des Lumières</p></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=1" id="1">
                        <div class="image image-slider-milieu salle1"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=2" id="2">
                        <div class="image image-slider salle2"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=3" id="3">
                        <div class="image image-slider salle3"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=4" id="4">
                        <div class="image image-slider salle4"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=5" id="5">
                        <div class="image image-slider salle5"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=2" id="1">
                        <div class="image image-slider clone2 salle1"></div>
                    </a>
                </div>
                <div class="js-photo">
                    <a href="salle.php?id=2" id="2">
                        <div class="image image-slider salle2"></div>
                    </a>
                </div>
            </div>
            <div class="js-navigation">
                <button class="slideLeft">
                    <span class="arrow-slider fleche gauche"></span>
                </button>
                <button class="slideRight">
                    <span class="arrow-slider fleche droite"></span>
                </button>
            </div>
        </div>
        <ul class="row-dots-slider">
            <li class="dots dots1"></li>
            <li class="dots dots2"></li>
            <li class="dots dots3"></li>
            <li class="dots dots4"></li>
            <li class="dots dots5"></li>
        </ul>
    </section>
    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>

    <script src="script.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>