<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - FAQ</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav"
                                href="nos-salles.php">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav"
                                href="a-propos.php">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>

    <section>
        <h1 class="title-faq">Les Questions Fréquentes !</h1>
        <details class="faq"><summary>Que se passe-t-il si je ne parviens pas à résoudre l’énigme et que je reste bloqué dans la salle ?</summary><p>Ne vous inquiétez pas, nous n'avons jamais perdu un joueur ! Si vous êtes vraiment bloqué, nos maîtres du jeu vous donneront quelques indices pour vous remettre sur la bonne voie. Et si ça ne suffit pas, ils viendront vous sauver !</p></details>
        <details class="faq"><summary>Combien de temps avant le début du jeu dois-je arriver ?</summary><p>Nous vous recommandons d'arriver 15 minutes avant l'heure prévue. Cela vous donne le temps de vous enregistrer, d'écouter les instructions et de vous préparer mentalement à devenir le prochain Sherlock Holmes !</p></details>
        <details class="faq"><summary>Que se passe-t-il si je casse quelque chose dans la salle ?</summary><p>Si quelque chose se casse accidentellement, pas de panique. Informez simplement votre maître du jeu. Nous vous demandons seulement de ne pas transformer les énigmes en séance de destruction !</p></details>
        <details class="faq"><summary>Puis-je réserver une salle pour une fête d'anniversaire ou un événement spécial ?</summary><p>Absolument ! Les escape games sont parfaits pour les anniversaires, les enterrements de vie de célibataire et même les team-buildings d'entreprise. Faites-nous savoir, et nous ferons en sorte que ce soit un événement mémorable !</p></details>
        <details class="faq"><summary>Et si je veux emmener ma grand-mère ? Elle est excellente aux mots croisés.</summary><p>Les grands-mères sont les bienvenues ! Elles pourraient bien être les membres les plus précieux de votre équipe. Après tout, l’expérience et la sagesse peuvent résoudre bien des énigmes.</p></details>
        <details class="faq"><summary>Puis-je apporter mon propre matériel, comme un pied-de-biche pour m’aider dans l’escape game ?</summary><p>Haha, nous apprécions votre dévouement, mais non, tous les outils nécessaires sont fournis dans la salle. Même les smartphones restent en dehors de la salle ;)</p></details>
    </section>

    <footer>
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php" style="color: #ffffff;">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>