<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Bruno+Ace&family=Jura:wght@300..700&family=League+Gothic&family=Montserrat:ital,wght@0,900;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="icon" href="img/fav-icon.png">
    <title>BrainOut - À Propos</title>
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <header>
        <a href="#contenu" class="sr-only skip-link">Aller au contenu</a>

        <div class="nav-wrapper">
            <nav>
                <div class="top-nav">
                    <a href="index.php" data-aos="fade-down" data-aos-duration="700"><img class="logo-nav"
                            src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                    <ul>
                        <li data-aos="fade-down" data-aos-duration="1000"><a class="link-nav"
                                href="le-concept.php">Le&nbsp;Concept</a></li>
                        <li data-aos="fade-down" data-aos-duration="1300"><a class="link-nav"
                                href="nos-salles.php">Nos&nbsp;Salles</a></li>
                        <li data-aos="fade-down" data-aos-duration="1600"><a class="link-nav" href="a-propos.php"
                                style="color: #ffffff;">À&nbsp;Propos</a></li>
                        <form action="nos-salles.php" method="get">
                            <input type="search" name="search" class="search-bar">
                            <button type="submit"><img class="search-icon" src="img/search-icon.png" alt=""></button>
                        </form>
                    </ul>
                </div>
            </nav>
        </div>
    </header>

    <section class="section-a-propos">
        <h1 class="title-a-propos">À Propos de BrainOut !</h1>
        <div class="timeline">
            <div class="outer">
                <div class="card">
                    <div class="info">
                        <h2 class="title" data-aos="fade-left" data-aos-duration="1000">L'Inspiration</h2>
                        <p data-aos="fade-left" data-aos-duration="1300">Ce projet naît grâce à un étudiant passionné par les escape games qui, après avoir constaté le potentiel de ce type de divertissement, décide de créer ses propres salles d'évasion. Il fonde BrainOut, une entreprise offrant des expériences immersives et innovantes pour les amateurs du genre. </p>
                    </div>
                </div>
                <div class="card">
                    <div class="info">
                        <h2 class="title" data-aos="fade-right" data-aos-duration="1000">Le Lancement</h2>
                        <p data-aos="fade-right" data-aos-duration="1300">Avec une première salle d'évasion inaugurée en ville, BrainOut attire rapidement l'attention grâce à ses scénarios immersifs et ses énigmes innovantes. Les premiers clients repartent enchantés, marquant le début prometteur d'une aventure captivante. </p>
                    </div>
                </div>
                <div class="card">
                    <div class="info">
                        <h2 class="title" data-aos="fade-left" data-aos-duration="1000">L'Expansion </h2>
                        <p data-aos="fade-left" data-aos-duration="1300">Porté par le succès de sa première salle d'évasion, BrainOut connaît une évolution. Grâce à une équipe dévouée et à un engagement constant envers l'innovation, BrainOut s'impose rapidement comme une référence incontournable dans le domaine des escape games. </p>
                    </div>
                </div>
                <div class="card">
                    <div class="info">
                        <h2 class="title" data-aos="fade-right" data-aos-duration="1000">La Nouveauté</h2>
                        <p data-aos="fade-right" data-aos-duration="1300">Toujours en quête de renouvellement, l'entreprise introduit une toute nouvelle expérience, la VR. Cette immersion en réalité virtuelle révolutionne le concept traditionnel d'escape game, offrant aux joueurs une expérience encore plus immersive et palpitante. Grâce à cette innovation audacieuse, BrainOut renforce sa réputation en tant que leader de l'industrie des jeux d'évasion. </p>
                    </div>
                </div>
                <div class="card">
                    <div class="info">
                        <h2 class="title" data-aos="fade-left" data-aos-duration="1000">À Vous De Jouer !</h2>
                        <p data-aos="fade-left" data-aos-duration="1300">Nous tenons à exprimer notre gratitude à tous les participants qui ont fait de BrainOut une véritable aventure. Votre enthousiasme et votre engagement ont été le moteur de notre succès. Nous vous invitons à découvrir nos dernières innovations et à vivre des expériences inoubliables avec nous. Rejoignez-nous chez BrainOut et laissez-vous emporter par le frisson de l'évasion !</p>
                    </div>
                </div>
            </div>
        </div>
        <img data-aos="fade-up" data-aos-duration="1400" src="img/createur.jpg" alt="" class="img-a-propos">
        <p data-aos="fade-up" data-aos-duration="1400" class="description-img-a-propos">Site entièrement développé par Gaël Grandval dans le cadre <br> d'un projet étudiant de 1ère année, au sein de la formation MMI de Champs-Sur-Marne.</p>

    </section>

    <footer class="footer-a-propos">
        <div class="footer-link">
            <ul>
                <li><a class="footer-links" href="mentions-legales.php">Mentions Légales</a></li>
                <li><a href="index.php"><img class="logo-nav" src="img/Logo-BrainOut.png" alt="Retourner à l'accueil"></a>
                </li>
                <li><a class="footer-links" href="faq.php">FAQ</a></li>
            </ul>
        </div>
        <span>Tous droits réservés, BrainOut © 2024</span>
    </footer>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>

</html>