<?php

function dbconnect(){
    $db=new PDO('mysql:host=localhost;dbname=grandval_blog;charset=utf8', 'grandval_admin','Kt2mVRZMwdx6fEb');
    return $db;
}

function InsertUser() {
    // Connexion à la base de données
    $db = dbconnect();
    
    // Préparation de la requête d'insertion
    $requete = 'INSERT INTO utilisateurs (nom, prenom, email, mdp) VALUES (:nom, :prenom, :email, :mdp)';
    $stmt = $db->prepare($requete);

    // Liaison des paramètres
    $stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
    $stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->bindParam(':mdp', password_hash($_POST['mdp'], PASSWORD_DEFAULT), PDO::PARAM_STR);

    // Exécution de la requête
    if (!$stmt->execute()) {
        exit("Erreur lors de l'insertion de l'utilisateur.");
    }

    // Récupération de l'ID de l'utilisateur inséré
    $userId = $db->lastInsertId();

    // Gestion du fichier uploadé s'il est présent
    if (isset($_FILES['fichier']) && $_FILES['fichier']['error'] === UPLOAD_ERR_OK) {
        $content_dir = 'img/'; 
        $tmp_file = $_FILES['fichier']['tmp_name'];

        // Vérifie que le fichier a bien été téléchargé temporairement
        if (!is_uploaded_file($tmp_file)) {
            exit("Le fichier est introuvable.");
        }

        // Récupère l'extension du fichier et génère un nouveau nom pour le fichier
        $extension = strtolower(pathinfo($_FILES['fichier']['name'], PATHINFO_EXTENSION));
        $nouveauNom = 'img' . $userId . '.' . $extension;

        // Assure que le répertoire de destination existe, le crée s'il est inexistant
        if (!is_dir($content_dir) && !mkdir($content_dir, 0777, true)) {
            exit("Erreur lors de la création du répertoire d'images.");
        }

        // Tente de déplacer le fichier dans le répertoire cible
        if (!move_uploaded_file($tmp_file, $content_dir . $nouveauNom)) {
            exit("Erreur lors du déplacement du fichier.");
        }

        return 'user-inserted';
    }
    else{
        return 'user-inserted';
    }
}


function TraiteInscription(){
    $db=dbconnect();
    $requete="SELECT * FROM utilisateurs WHERE email=:email";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->execute();
    if ($utilisateur = $stmt->fetch(PDO::FETCH_ASSOC)){
        return 'email-inscription-error';
    }
    elseif($_POST['mdp']!=$_POST['mdp_verif']){
        return 'mdp-inscription-error';
    }
    else{
        InsertUser();
        return 'user-inserted';
    }
}


function DeleteUser($id){
    $db=dbconnect();
    $requete='DELETE FROM utilisateurs WHERE id_utilisateur=:id';
    $stmt=$db->prepare($requete);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    return 'user-deleted';
}

function AfficheUtilisateurs(){
    $db=dbconnect();
    $requete = "SELECT * FROM utilisateurs";
    $stmt = $db->query($requete);
    return $stmt;
}

function Affiche1Utilisateur($id){
    $db=dbconnect();
    $requete = "SELECT * FROM utilisateurs WHERE id_utilisateur=:id";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
}


function TraiteConnexion(){
    $db=dbconnect();
    $requete="SELECT * FROM utilisateurs WHERE email=:email";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->execute();
    if ($utilisateur = $stmt->fetch(PDO::FETCH_ASSOC)){
        if (password_verify($_POST['mdp'], $utilisateur['mdp'])){
            session_start();
            $_SESSION['id_utilisateur']=$utilisateur['id_utilisateur'];
            $_SESSION['nom']=$utilisateur['nom'];
            $_SESSION['prenom']=$utilisateur['prenom'];
            $_SESSION['email']=$utilisateur['email'];
            return 'user-connected';
        }
        else{
            return 'mdp-connexion-error';
        }
    }
    else{
        return 'email-connexion-error';
    }
}

function TraiteDeconnexion(){
    session_start();
    $_SESSION = array();
    session_destroy();
    return 'user-deconnected';
}

function InsertBillet(){
    $db=dbconnect();
    $requete= 'INSERT INTO billets(titre, contenu) VALUES (:titre, :contenu_billet)';
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':titre', $_POST['titre'], PDO::PARAM_STR);
    $stmt->bindParam(':contenu_billet', nl2br($_POST['contenu_billet']), PDO::PARAM_STR);
    $stmt->execute();
    return 'billet-inserted';
}

function InsertCommentaire(){
    $db=dbconnect();
    $requete= 'INSERT INTO commentaires (contenu, utilisateur_id, billet_id) VALUES (:contenu_commentaire, :utilisateur_id, :billet_id)';
    $stmt = $db->prepare($requete); 
    $stmt->bindParam(':contenu_commentaire', nl2br($_POST['contenu']), PDO::PARAM_STR);
    $stmt->bindParam(':utilisateur_id', $_SESSION['id_utilisateur'], PDO::PARAM_INT);
    $stmt->bindParam(':billet_id', $_GET['id_billet'], PDO::PARAM_INT);
    $stmt->execute();
    return 'commentaire-inserted';
}

function DeleteCommentaire($id){
    $db=dbconnect();
    $requete='DELETE FROM commentaires WHERE id_commentaire=:id';
    $stmt=$db->prepare($requete);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    return 'commentaire-deleted';
}

function DeleteBillet($id){
    $db=dbconnect();
    $requete='DELETE FROM billets WHERE id_billet=:id';
    $stmt=$db->prepare($requete);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    return 'billet-deleted';
}


function AfficheBillets(){
    $db=dbconnect();
    $requete = "SELECT * FROM billets ORDER BY date_creation DESC";
    $stmt = $db->query($requete);
    return $stmt;
}

function Affiche3Billets(){
    $db=dbconnect();
    $requete = "SELECT * FROM billets ORDER BY date_creation DESC LIMIT 3";
    $stmt = $db->query($requete);
    return $stmt;
}

function Affiche1Billet($id_billet){
    $db=dbconnect();
    $requete = "SELECT * FROM billets WHERE id_billet=:id_billet";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':id_billet', $id_billet, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
}

function TraiteUpdateBillet(){
    $db=dbconnect();
    if ($_POST['titre']=='' or $_POST['contenu']==''){
        return 'billet-modif-error';
    }
    else{
        $requete= 'UPDATE billets SET titre=:titre, contenu=:contenu WHERE id_billet=:id';
        $stmt = $db->prepare($requete);
        $stmt->bindParam(':titre', $_POST['titre'], PDO::PARAM_STR);
        $stmt->bindParam(':contenu', nl2br($_POST['contenu']), PDO::PARAM_STR);
        $stmt->bindParam(':id', $_GET['id_billet'], PDO::PARAM_INT);
        $stmt->execute();
        return 'billet-modified';
    }
    
}

function TraiteUpdateCommentaire(){
    $db=dbconnect();
    if ($_POST['contenu']==''){
        return 'commentaire-modif-error';
    }
    else{
        $requete= 'UPDATE commentaires SET contenu=:contenu WHERE id_commentaire=:id';
        $stmt = $db->prepare($requete);
        $stmt->bindParam(':contenu', nl2br($_POST['contenu']), PDO::PARAM_STR);
        $stmt->bindParam(':id', $_GET['id_commentaire'], PDO::PARAM_INT);
        $stmt->execute();
        return 'commentaire-modified';
    }
    
}


function AfficheAuteurCom($id){
    $db=dbconnect();
    $requete = "SELECT nom, prenom FROM utilisateurs WHERE id_utilisateur =:id_utilisateur";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':id_utilisateur', $id , PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
}

function AfficheCommentaires($id_billet){
    $db=dbconnect();
    $requete = "SELECT * FROM commentaires WHERE billet_id=:id_billet ORDER BY date_creation DESC";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':id_billet', $id_billet, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
}
function Affiche1Commentaire($id_commentaire){
    $db=dbconnect();
    $requete = "SELECT * FROM commentaires WHERE id_commentaire=:id_commentaire";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':id_commentaire', $id_commentaire, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
}

function TraiteModifUtilisateur($id) {
    $db = dbconnect();

    // Vérifier si l'email est déjà utilisé par un autre utilisateur
    $requete = "SELECT * FROM utilisateurs WHERE email = :email";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->execute();

    // Vérifier s'il y a un résultat
    if ($stmt->rowCount() > 0) {
        $utilisateur = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Si l'email appartient à un autre utilisateur, renvoyer une erreur
        if ($utilisateur['id_utilisateur'] != $id) {
            return 'email-modif-error';
        }
    }

    // Mise à jour des informations de l'utilisateur
    $requete = 'UPDATE utilisateurs SET nom = :nom, prenom = :prenom, email = :email WHERE id_utilisateur = :id';
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
    $stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    // Gestion du fichier uploadé s'il est présent
    if (isset($_FILES['fichier']['error']) && $_FILES['fichier']['error'] === UPLOAD_ERR_OK) {
        $content_dir = 'img/'; 
        $tmp_file = $_FILES['fichier']['tmp_name'];

        // Vérifie que le fichier est bien téléchargé temporairement
        if (!is_uploaded_file($tmp_file)) {
            exit("Le fichier est introuvable.");
        }

        // Récupère l'extension du fichier et génère un nouveau nom pour le fichier
        $extension = strtolower(pathinfo($_FILES['fichier']['name'], PATHINFO_EXTENSION));
        $nouveauNom = 'img' . $id . '.' . $extension;

        // Supprime les anciennes photos de profil de l'utilisateur pour éviter les doublons
        foreach (glob($content_dir . 'img' . $id . '.*') as $oldFile) {
            unlink($oldFile);
        }

        // Tente de déplacer le fichier dans le répertoire cible avec le nouveau nom
        if (!move_uploaded_file($tmp_file, $content_dir . $nouveauNom)) {
            exit("Erreur lors du déplacement du fichier.");
        }
    }

    return 'user-modified';
}


function TraiteModifProfil() {
    $db = dbconnect();

    // Vérification de la correspondance des mots de passe
    if ($_POST['mdp'] !== $_POST['mdp_verif']) {
        return 'mdp-modif-error';
    }

    // Préparation de la requête pour vérifier si l'email existe déjà
    $requete = "SELECT * FROM utilisateurs WHERE email = :email";
    $stmt = $db->prepare($requete);
    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $stmt->execute();

    if ($utilisateur = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Si l'email appartient à un autre utilisateur
        if ($utilisateur['id_utilisateur'] != $_SESSION['id_utilisateur']) {
            return 'email-modif-error';
        }
    }

    // Préparation de la requête de mise à jour
    $requete = 'UPDATE utilisateurs 
                SET nom = :nom, prenom = :prenom, email = :email, mdp = :mdp 
                WHERE id_utilisateur = :id';
    $stmt = $db->prepare($requete);

    $stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
    $_SESSION['nom'] = $_POST['nom'];

    $stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
    $_SESSION['prenom'] = $_POST['prenom'];

    $stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
    $_SESSION['email'] = $_POST['email'];

    if ($_POST['mdp'] !== '') {
        $hashedPassword = password_hash($_POST['mdp'], PASSWORD_DEFAULT);
    } else {
        $hashedPassword = $_utilisateur['mdp'];
    }
    $stmt->bindParam(':mdp', $hashedPassword, PDO::PARAM_STR);

    $stmt->bindParam(':id', $_SESSION['id_utilisateur'], PDO::PARAM_INT);


    // Gestion du fichier uploadé
    if (isset($_FILES['fichier']['error']) && $_FILES['fichier']['error'] === UPLOAD_ERR_OK) {
        $content_dir = 'img/';
        $tmp_file = $_FILES['fichier']['tmp_name'];

        // Vérifie que le fichier est bien téléchargé temporairement
        if (!is_uploaded_file($tmp_file)) {
            return "file-upload-error";
            
        
        }
        

        // Récupère l'extension du fichier
        $extension = strtolower(pathinfo($_FILES['fichier']['name'], PATHINFO_EXTENSION));
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];

        if (!in_array($extension, $allowed_extensions)) {
            return "invalid-file-type";
        }

        // Génère un nouveau nom pour le fichier
        $nouveauNom = 'img' . $_SESSION['id_utilisateur'] . '.' . $extension;

        // Supprime les anciennes photos de profil
        foreach (glob($content_dir . 'img' . $_SESSION['id_utilisateur'] . '.*') as $oldFile) {
            unlink($oldFile);
        }

        // Déplace le fichier dans le répertoire cible
        if (!move_uploaded_file($tmp_file, $content_dir . $nouveauNom)) {
            return "file-move-error";
        }
    }

    return 'user-modified';
}


?>